![Twilio Sans Mono written in Twilio Sans Mono on a red background](./screenshots//mono-header@2x.png)

Twilio worked very closely with the type foundry, Sharp Type over the course of two years to develop a welcoming and adaptable typeface designed specifically for Twilio, Twilio Sans. Twilio Sans is a super family composed of display fonts, text fonts, and mono fonts.

Twilio Sans Mono is a distinct programming font designed to fit the needs of every developer — no matter their code editor, no matter their preferred programming language, and no matter their project. You can download Twilio Sans Mono for free today and use it in your favorite code editor.

## Features

### Variants

Twilio Sans Mono contains eight weights, each with roman and true italics:

![Screenshot of the included weights of Light, Medium, Regular, Retina, Semibold, Bold, Extrabold and Heavy as well as their respective italics versions](./screenshots/mono-weights-light@2x.png#gh-light-mode-only)
![Screenshot of the included weights of Light, Medium, Regular, Retina, Semibold, Bold, Extrabold and Heavy as well as their respective italics versions](./screenshots/mono-weights-dark@2x.png#gh-dark-mode-only)

### Coding Ligatures

![Screenshot of the included ligatures](./screenshots/mono-coding-ligatures-light@2x.png#gh-light-mode-only)
![Screenshot of the included ligatures](./screenshots/mono-coding-ligatures-dark@2x.png#gh-dark-mode-only)

### Arrows

![Screenshot of the included arrow ligatures that are included in Twilio Sans Mono](./screenshots/mono-arrows-light@2x.png#gh-light-mode-only)
![Screenshot of the included arrow ligatures that are included in Twilio Sans Mono](./screenshots/mono-arrows-dark@2x.png#gh-dark-mode-only)

## Usage Instructions

### Downloading Twilio Sans Mono

[Download the `Twilio-Sans-Mono.zip`](https://github.com/twilio/twilio-sans-mono/raw/main/Twilio-Sans-Mono.zip) file from this repository, unzip it, and install the fonts with your operating system’s font tools. Often, just selecting all the fonts you want to install and double clicking them opens up the appropriate tool.

### Usage with VS Code

In `settings.json`:

```json
"editor.fontFamily": "Twilio Sans Mono",
"editor.fontLigatures": true,
```

_Note: If you’d like to see instructions for your favorite editor and it's not already included, please feel free to submit a Pull Request._

## How we Maintain this Repository

The repository will not actively be monitored, aside from troubleshooting and fixing bugs. We do welcome Issues and Pull Requests, but don't guarantee that we'll be able to address them.

## Thanks

We’d like to extend a huge thank you to our partner who designed our new typeface, Chantra and Lucas Sharp at Sharp Type LLC. We loved working with you on this project and are so happy with the final design.

Thank you also to our contributors at Twilio who provided invaluable feedback and put the typeface to the test in a multitude of environments. Thank you to:

* Dominik Kundel
* Jamie Wilson
* Katie Porter
* Sean McBride
* Serena Buxton
* Kelly Kuhl
* Jennie Janzen
* Nathan Sharp

Thank you to our legal team who made an open sourced Twilio Sans Mono a reality:

* Marisa Chen
* Rinat Shangeeta
* Eugene Kim

## Code of Conduct

Please review [Twilio’s Code of Conduct documentation](https://github.com/twilio/.github/blob/master/CODE_OF_CONDUCT.md). Our expectation is for all users to abide by our code of conduct or their ability to interact will be removed.
